package com.bycom.versapro.Activities;

import static com.bycom.versapro.Config.introPages;
import static com.bycom.versapro.Utils.PrefUtil.setIntroCompleted;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;

import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;

import com.bycom.versapro.R;



import render.animations.Attention;
import render.animations.Render;

public class IntroActivity extends AppCompatActivity {


    int currentPage = 0;
    ImageView iv_right;
    ImageView iv_left;
    TextView tv_message;
    View mcv_message;
    View mcv_left;
    View mcv_right;
    RelativeLayout relativeLayout;

    View.OnClickListener nextPageOnClick,lastPageOnClick;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_intro);
        EdgeToEdge.enable(this);





         iv_right = findViewById(R.id.iv_right);
         iv_left = findViewById(R.id.iv_left);
         tv_message = findViewById(R.id.tv_message);
         mcv_message = findViewById(R.id.mcv_message);
         mcv_left = findViewById(R.id.mcv_left);
         mcv_right = findViewById(R.id.mcv_right);
         relativeLayout = findViewById(R.id.rl_buttons);



        mcv_left.setVisibility(View.GONE);



        tv_message.setText(introPages.get(0));

        Transition transition = new AutoTransition();



        nextPageOnClick = view -> {

            TransitionManager.beginDelayedTransition(relativeLayout, transition);
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mcv_right.getLayoutParams();
            params.removeRule(RelativeLayout.ALIGN_PARENT_START);
            mcv_right.setLayoutParams(params);

            currentPage ++;
            if(currentPage != 0) mcv_left.setVisibility(View.VISIBLE);
            if(currentPage == introPages.size()-1){
                setupLastPageButton();
            }

           changePage();
        };


        lastPageOnClick = view -> {
            setIntroCompleted(true);
            finish();
            startActivity(new Intent(IntroActivity.this,MainActivity.class));
            overridePendingTransition(R.anim.fade_in,R.anim.fade_out);
        };




        iv_left.setOnClickListener(view -> {
            currentPage --;
            if(currentPage == 0) {
                TransitionManager.beginDelayedTransition(relativeLayout, transition);
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mcv_right.getLayoutParams();
                params.addRule(RelativeLayout.ALIGN_PARENT_START, RelativeLayout.TRUE);
                mcv_right.setLayoutParams(params);
                mcv_left.setVisibility(View.GONE);
            }
            if(currentPage != introPages.size()-1) {
                iv_right.setImageResource(R.drawable.ic_right);
                iv_right.setOnClickListener(nextPageOnClick);

            }
            changePage();
        });



        if(introPages.size()==1){
            setupLastPageButton();
        }else setupNextPageButton();



    }


    public void setupNextPageButton(){
        iv_right.setImageResource(R.drawable.ic_right);
        iv_right.setOnClickListener(nextPageOnClick);
    }

    public void setupLastPageButton(){
        iv_right.setImageResource(R.drawable.ic_check);
        iv_right.setOnClickListener(lastPageOnClick);
    }


    public void changePage(){
        Render render = new Render(IntroActivity.this);
        render.setAnimation(Attention.RuberBand(mcv_message));
        render.setDuration(500);
        render.start();

        new Handler().postDelayed(() -> tv_message.setText(introPages.get(currentPage)),250);
    }



}